<?php
include(__DIR__.'/class/3_architectureDesignPatterns.class.php');

// Client code
$queue = [];
$commandQueue = new CommandQueue();

$command1 = new AddItemCommand($queue, 'Open the door');
$command2 = new AddItemCommand($queue, 'Close the door');
$command3 = new AddItemCommand($queue, 'Open the door');

$commandQueue->addCommand($command1);
$commandQueue->addCommand($command2);
$commandQueue->addCommand($command3);

$commandQueue->processCommands();

$commandQueue->undoLastCommand();
$commandQueue->redoLastUndoneCommand();

// Output: Array ( [0] => Open the door [1] => Close the door [2] => Open the door )
echo '<pre>',print_r($queue),'</pre>';
