<?php
class PrimeNumbers
{
    public static function primeSumInInterval($start, $end)
    {
        // Initialize an array for the Sieve of Eratosthenes, marking all numbers as prime.
        $sieve = array_fill(2, $end, true);

        // Apply the Sieve of Eratosthenes to mark multiples of prime numbers as non-prime.
        for ($i = 2; $i * $i <= $end; $i++) {
            if ($sieve[$i]) {
                for ($j = $i * $i; $j <= $end; $j += $i)
                {
                    $sieve[$j] = false;
                }
            }
        }

        // Calculate the sum of prime numbers within the specified range.
        $sum = 0;
        for ($i = $start; $i <= $end; $i++)
        {
            if ($sieve[$i])
            {
                $sum += $i;
            }
        }

        return $sum;
    }
}